package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertiesPropertyArgs private(
  contractId: Output[String],
  groupId: Output[String],
  latestVersion: Output[Int],
  note: Output[String],
  productId: Output[String],
  productionVersion: Output[Int],
  propertyId: Output[String],
  propertyName: Output[String],
  ruleFormat: Output[String],
  stagingVersion: Output[Int]
) derives Encoder, ArgsEncoder

object GetPropertiesPropertyArgs:
  def apply(
    contractId: Input[String],
    groupId: Input[String],
    latestVersion: Input[Int],
    note: Input[String],
    productId: Input[String],
    productionVersion: Input[Int],
    propertyId: Input[String],
    propertyName: Input[String],
    ruleFormat: Input[String],
    stagingVersion: Input[Int]
  )(using Context): GetPropertiesPropertyArgs =
    new GetPropertiesPropertyArgs(
      contractId = contractId.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      latestVersion = latestVersion.asOutput(isSecret = false),
      note = note.asOutput(isSecret = false),
      productId = productId.asOutput(isSecret = false),
      productionVersion = productionVersion.asOutput(isSecret = false),
      propertyId = propertyId.asOutput(isSecret = false),
      propertyName = propertyName.asOutput(isSecret = false),
      ruleFormat = ruleFormat.asOutput(isSecret = false),
      stagingVersion = stagingVersion.asOutput(isSecret = false)
    )
