package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertiesSearchPropertyArgs private(
  accountId: Output[String],
  assetId: Output[String],
  contractId: Output[String],
  edgeHostname: Output[String],
  groupId: Output[String],
  hostname: Output[String],
  productionStatus: Output[String],
  propertyId: Output[String],
  propertyName: Output[String],
  propertyVersion: Output[Int],
  stagingStatus: Output[String],
  updatedByUser: Output[String],
  updatedDate: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertiesSearchPropertyArgs:
  def apply(
    accountId: Input[String],
    assetId: Input[String],
    contractId: Input[String],
    edgeHostname: Input[String],
    groupId: Input[String],
    hostname: Input[String],
    productionStatus: Input[String],
    propertyId: Input[String],
    propertyName: Input[String],
    propertyVersion: Input[Int],
    stagingStatus: Input[String],
    updatedByUser: Input[String],
    updatedDate: Input[String]
  )(using Context): GetPropertiesSearchPropertyArgs =
    new GetPropertiesSearchPropertyArgs(
      accountId = accountId.asOutput(isSecret = false),
      assetId = assetId.asOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      edgeHostname = edgeHostname.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      hostname = hostname.asOutput(isSecret = false),
      productionStatus = productionStatus.asOutput(isSecret = false),
      propertyId = propertyId.asOutput(isSecret = false),
      propertyName = propertyName.asOutput(isSecret = false),
      propertyVersion = propertyVersion.asOutput(isSecret = false),
      stagingStatus = stagingStatus.asOutput(isSecret = false),
      updatedByUser = updatedByUser.asOutput(isSecret = false),
      updatedDate = updatedDate.asOutput(isSecret = false)
    )
