package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyHostnamesHostnameArgs private(
  certProvisioningType: Output[String],
  certStatuses: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetPropertyHostnamesHostnameCertStatusArgs]],
  cnameFrom: Output[String],
  cnameTo: Output[String],
  cnameType: Output[String],
  edgeHostnameId: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyHostnamesHostnameArgs:
  def apply(
    certProvisioningType: Input[String],
    certStatuses: Input[List[Input[besom.api.akamai.inputs.GetPropertyHostnamesHostnameCertStatusArgs]]],
    cnameFrom: Input[String],
    cnameTo: Input[String],
    cnameType: Input[String],
    edgeHostnameId: Input[String]
  )(using Context): GetPropertyHostnamesHostnameArgs =
    new GetPropertyHostnamesHostnameArgs(
      certProvisioningType = certProvisioningType.asOutput(isSecret = false),
      certStatuses = certStatuses.asOutput(isSecret = false),
      cnameFrom = cnameFrom.asOutput(isSecret = false),
      cnameTo = cnameTo.asOutput(isSecret = false),
      cnameType = cnameType.asOutput(isSecret = false),
      edgeHostnameId = edgeHostnameId.asOutput(isSecret = false)
    )
