package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyHostnamesHostnameCertStatusArgs private(
  hostname: Output[String],
  productionStatus: Output[String],
  stagingStatus: Output[String],
  target: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyHostnamesHostnameCertStatusArgs:
  def apply(
    hostname: Input[String],
    productionStatus: Input[String],
    stagingStatus: Input[String],
    target: Input[String]
  )(using Context): GetPropertyHostnamesHostnameCertStatusArgs =
    new GetPropertyHostnamesHostnameCertStatusArgs(
      hostname = hostname.asOutput(isSecret = false),
      productionStatus = productionStatus.asOutput(isSecret = false),
      stagingStatus = stagingStatus.asOutput(isSecret = false),
      target = target.asOutput(isSecret = false)
    )
