package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyIncludeParentsParentArgs private(
  id: Output[String],
  isIncludeUsedInProductionVersion: Output[Boolean],
  isIncludeUsedInStagingVersion: Output[Boolean],
  name: Output[String],
  productionVersion: Output[String],
  stagingVersion: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyIncludeParentsParentArgs:
  def apply(
    id: Input[String],
    isIncludeUsedInProductionVersion: Input[Boolean],
    isIncludeUsedInStagingVersion: Input[Boolean],
    name: Input[String],
    productionVersion: Input[String],
    stagingVersion: Input[String]
  )(using Context): GetPropertyIncludeParentsParentArgs =
    new GetPropertyIncludeParentsParentArgs(
      id = id.asOutput(isSecret = false),
      isIncludeUsedInProductionVersion = isIncludeUsedInProductionVersion.asOutput(isSecret = false),
      isIncludeUsedInStagingVersion = isIncludeUsedInStagingVersion.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      productionVersion = productionVersion.asOutput(isSecret = false),
      stagingVersion = stagingVersion.asOutput(isSecret = false)
    )
