package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyIncludesIncludeArgs private(
  id: Output[String],
  latestVersion: Output[Int],
  name: Output[String],
  productionVersion: Output[String],
  stagingVersion: Output[String],
  `type`: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyIncludesIncludeArgs:
  def apply(
    id: Input[String],
    latestVersion: Input[Int],
    name: Input[String],
    productionVersion: Input[String],
    stagingVersion: Input[String],
    `type`: Input[String]
  )(using Context): GetPropertyIncludesIncludeArgs =
    new GetPropertyIncludesIncludeArgs(
      id = id.asOutput(isSecret = false),
      latestVersion = latestVersion.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      productionVersion = productionVersion.asOutput(isSecret = false),
      stagingVersion = stagingVersion.asOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
