package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyIncludesParentPropertyArgs private(
  id: Output[String],
  version: Output[Int]
) derives Encoder, ArgsEncoder

object GetPropertyIncludesParentPropertyArgs:
  def apply(
    id: Input[String],
    version: Input[Int]
  )(using Context): GetPropertyIncludesParentPropertyArgs =
    new GetPropertyIncludesParentPropertyArgs(
      id = id.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
