package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyProductsProductArgs private(
  productId: Output[String],
  productName: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyProductsProductArgs:
  def apply(
    productId: Input[String],
    productName: Input[String]
  )(using Context): GetPropertyProductsProductArgs =
    new GetPropertyProductsProductArgs(
      productId = productId.asOutput(isSecret = false),
      productName = productName.asOutput(isSecret = false)
    )
