package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorAllowCloudletsOriginsArgs private(
  enabled: Output[Option[Boolean]],
  honorBaseDirectory: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  purgeOriginQueryParameter: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorAllowCloudletsOriginsArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    honorBaseDirectory: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    purgeOriginQueryParameter: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorAllowCloudletsOriginsArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorAllowCloudletsOriginsArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      honorBaseDirectory = honorBaseDirectory.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      purgeOriginQueryParameter = purgeOriginQueryParameter.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
