package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorCacheKeyQueryParamsArgs private(
  behavior: Output[Option[String]],
  exactMatch: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  parameters: Output[Option[scala.collection.immutable.List[String]]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorCacheKeyQueryParamsArgs:
  def apply(
    behavior: Input.Optional[String] = None,
    exactMatch: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    parameters: Input.Optional[List[Input[String]]] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorCacheKeyQueryParamsArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorCacheKeyQueryParamsArgs(
      behavior = behavior.asOptionOutput(isSecret = false),
      exactMatch = exactMatch.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      parameters = parameters.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
