package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsAmdArgs private(
  catalogSize: Output[Option[String]],
  contentType: Output[Option[String]],
  dash: Output[Option[Boolean]],
  hds: Output[Option[Boolean]],
  hls: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  popularityDistribution: Output[Option[String]],
  segmentDurationDash: Output[Option[String]],
  segmentDurationDashCustom: Output[Option[Int]],
  segmentDurationHds: Output[Option[String]],
  segmentDurationHdsCustom: Output[Option[Int]],
  segmentDurationHls: Output[Option[String]],
  segmentDurationHlsCustom: Output[Option[Double]],
  segmentDurationSmooth: Output[Option[String]],
  segmentDurationSmoothCustom: Output[Option[Double]],
  segmentSizeDash: Output[Option[String]],
  segmentSizeHds: Output[Option[String]],
  segmentSizeHls: Output[Option[String]],
  segmentSizeSmooth: Output[Option[String]],
  smooth: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsAmdArgs:
  def apply(
    catalogSize: Input.Optional[String] = None,
    contentType: Input.Optional[String] = None,
    dash: Input.Optional[Boolean] = None,
    hds: Input.Optional[Boolean] = None,
    hls: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    popularityDistribution: Input.Optional[String] = None,
    segmentDurationDash: Input.Optional[String] = None,
    segmentDurationDashCustom: Input.Optional[Int] = None,
    segmentDurationHds: Input.Optional[String] = None,
    segmentDurationHdsCustom: Input.Optional[Int] = None,
    segmentDurationHls: Input.Optional[String] = None,
    segmentDurationHlsCustom: Input.Optional[Double] = None,
    segmentDurationSmooth: Input.Optional[String] = None,
    segmentDurationSmoothCustom: Input.Optional[Double] = None,
    segmentSizeDash: Input.Optional[String] = None,
    segmentSizeHds: Input.Optional[String] = None,
    segmentSizeHls: Input.Optional[String] = None,
    segmentSizeSmooth: Input.Optional[String] = None,
    smooth: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsAmdArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsAmdArgs(
      catalogSize = catalogSize.asOptionOutput(isSecret = false),
      contentType = contentType.asOptionOutput(isSecret = false),
      dash = dash.asOptionOutput(isSecret = false),
      hds = hds.asOptionOutput(isSecret = false),
      hls = hls.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      popularityDistribution = popularityDistribution.asOptionOutput(isSecret = false),
      segmentDurationDash = segmentDurationDash.asOptionOutput(isSecret = false),
      segmentDurationDashCustom = segmentDurationDashCustom.asOptionOutput(isSecret = false),
      segmentDurationHds = segmentDurationHds.asOptionOutput(isSecret = false),
      segmentDurationHdsCustom = segmentDurationHdsCustom.asOptionOutput(isSecret = false),
      segmentDurationHls = segmentDurationHls.asOptionOutput(isSecret = false),
      segmentDurationHlsCustom = segmentDurationHlsCustom.asOptionOutput(isSecret = false),
      segmentDurationSmooth = segmentDurationSmooth.asOptionOutput(isSecret = false),
      segmentDurationSmoothCustom = segmentDurationSmoothCustom.asOptionOutput(isSecret = false),
      segmentSizeDash = segmentSizeDash.asOptionOutput(isSecret = false),
      segmentSizeHds = segmentSizeHds.asOptionOutput(isSecret = false),
      segmentSizeHls = segmentSizeHls.asOptionOutput(isSecret = false),
      segmentSizeSmooth = segmentSizeSmooth.asOptionOutput(isSecret = false),
      smooth = smooth.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
