package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsArgs private(
  catalogSize: Output[Option[String]],
  contentType: Output[Option[String]],
  locked: Output[Option[Boolean]],
  objectSize: Output[Option[String]],
  popularityDistribution: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsArgs:
  def apply(
    catalogSize: Input.Optional[String] = None,
    contentType: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    objectSize: Input.Optional[String] = None,
    popularityDistribution: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorContentCharacteristicsArgs(
      catalogSize = catalogSize.asOptionOutput(isSecret = false),
      contentType = contentType.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      objectSize = objectSize.asOptionOutput(isSecret = false),
      popularityDistribution = popularityDistribution.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
