package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorContentPrePositionArgs private(
  enabled: Output[Option[Boolean]],
  firstLocation: Output[Option[String]],
  locked: Output[Option[Boolean]],
  secondLocation: Output[Option[String]],
  sourceType: Output[Option[String]],
  targets: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorContentPrePositionArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    firstLocation: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    secondLocation: Input.Optional[String] = None,
    sourceType: Input.Optional[String] = None,
    targets: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorContentPrePositionArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorContentPrePositionArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      firstLocation = firstLocation.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      secondLocation = secondLocation.asOptionOutput(isSecret = false),
      sourceType = sourceType.asOptionOutput(isSecret = false),
      targets = targets.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
