package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorDynamicWebContentArgs private(
  imageCompression: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  prefetch: Output[Option[Boolean]],
  realUserMonitoring: Output[Option[Boolean]],
  sureRoute: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorDynamicWebContentArgs:
  def apply(
    imageCompression: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    prefetch: Input.Optional[Boolean] = None,
    realUserMonitoring: Input.Optional[Boolean] = None,
    sureRoute: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorDynamicWebContentArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorDynamicWebContentArgs(
      imageCompression = imageCompression.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      prefetch = prefetch.asOptionOutput(isSecret = false),
      realUserMonitoring = realUserMonitoring.asOptionOutput(isSecret = false),
      sureRoute = sureRoute.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
