package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorEcmsDatasetArgs private(
  dataset: Output[Option[String]],
  extractLocation: Output[Option[String]],
  headerName: Output[Option[String]],
  locked: Output[Option[Boolean]],
  queryParameterName: Output[Option[String]],
  regexPattern: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorEcmsDatasetArgs:
  def apply(
    dataset: Input.Optional[String] = None,
    extractLocation: Input.Optional[String] = None,
    headerName: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    queryParameterName: Input.Optional[String] = None,
    regexPattern: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorEcmsDatasetArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorEcmsDatasetArgs(
      dataset = dataset.asOptionOutput(isSecret = false),
      extractLocation = extractLocation.asOptionOutput(isSecret = false),
      headerName = headerName.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      queryParameterName = queryParameterName.asOptionOutput(isSecret = false),
      regexPattern = regexPattern.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
