package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingDataCenterFailoverRuleArgs private(
  absolutePath: Output[Option[Boolean]],
  contextRoot: Output[Option[String]],
  failoverHostname: Output[Option[String]],
  modifyRequest: Output[Option[Boolean]],
  overrideHostname: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingDataCenterFailoverRuleArgs:
  def apply(
    absolutePath: Input.Optional[Boolean] = None,
    contextRoot: Input.Optional[String] = None,
    failoverHostname: Input.Optional[String] = None,
    modifyRequest: Input.Optional[Boolean] = None,
    overrideHostname: Input.Optional[Boolean] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingDataCenterFailoverRuleArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingDataCenterFailoverRuleArgs(
      absolutePath = absolutePath.asOptionOutput(isSecret = false),
      contextRoot = contextRoot.asOptionOutput(isSecret = false),
      failoverHostname = failoverHostname.asOptionOutput(isSecret = false),
      modifyRequest = modifyRequest.asOptionOutput(isSecret = false),
      overrideHostname = overrideHostname.asOptionOutput(isSecret = false)
    )
