package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingOriginArgs private(
  cookieName: Output[Option[String]],
  description: Output[Option[String]],
  enableSessionPersistence: Output[Option[Boolean]],
  hostname: Output[Option[String]],
  id: Output[Option[String]],
  locked: Output[Option[Boolean]],
  sessionPersistenceTitle: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingOriginArgs:
  def apply(
    cookieName: Input.Optional[String] = None,
    description: Input.Optional[String] = None,
    enableSessionPersistence: Input.Optional[Boolean] = None,
    hostname: Input.Optional[String] = None,
    id: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    sessionPersistenceTitle: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingOriginArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorEdgeLoadBalancingOriginArgs(
      cookieName = cookieName.asOptionOutput(isSecret = false),
      description = description.asOptionOutput(isSecret = false),
      enableSessionPersistence = enableSessionPersistence.asOptionOutput(isSecret = false),
      hostname = hostname.asOptionOutput(isSecret = false),
      id = id.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      sessionPersistenceTitle = sessionPersistenceTitle.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
