package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorG2oheaderArgs private(
  customSignStrings: Output[Option[scala.collection.immutable.List[String]]],
  dataHeader: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  encodingVersion: Output[Option[Int]],
  locked: Output[Option[Boolean]],
  nonce: Output[Option[String]],
  secretKey: Output[Option[String]],
  signedHeader: Output[Option[String]],
  templateUuid: Output[Option[String]],
  useCustomSignString: Output[Option[Boolean]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorG2oheaderArgs:
  def apply(
    customSignStrings: Input.Optional[List[Input[String]]] = None,
    dataHeader: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    encodingVersion: Input.Optional[Int] = None,
    locked: Input.Optional[Boolean] = None,
    nonce: Input.Optional[String] = None,
    secretKey: Input.Optional[String] = None,
    signedHeader: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    useCustomSignString: Input.Optional[Boolean] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorG2oheaderArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorG2oheaderArgs(
      customSignStrings = customSignStrings.asOptionOutput(isSecret = false),
      dataHeader = dataHeader.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      encodingVersion = encodingVersion.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      nonce = nonce.asOptionOutput(isSecret = false),
      secretKey = secretKey.asOptionOutput(isSecret = false),
      signedHeader = signedHeader.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      useCustomSignString = useCustomSignString.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
