package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorGraphqlCachingArgs private(
  advanced: Output[Option[String]],
  cacheResponsesWithErrors: Output[Option[Boolean]],
  enabled: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  operationsJsonBodyParameterName: Output[Option[String]],
  operationsUrlQueryParameterName: Output[Option[String]],
  postRequestProcessingErrorHandling: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorGraphqlCachingArgs:
  def apply(
    advanced: Input.Optional[String] = None,
    cacheResponsesWithErrors: Input.Optional[Boolean] = None,
    enabled: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    operationsJsonBodyParameterName: Input.Optional[String] = None,
    operationsUrlQueryParameterName: Input.Optional[String] = None,
    postRequestProcessingErrorHandling: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorGraphqlCachingArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorGraphqlCachingArgs(
      advanced = advanced.asOptionOutput(isSecret = false),
      cacheResponsesWithErrors = cacheResponsesWithErrors.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      operationsJsonBodyParameterName = operationsJsonBodyParameterName.asOptionOutput(isSecret = false),
      operationsUrlQueryParameterName = operationsUrlQueryParameterName.asOptionOutput(isSecret = false),
      postRequestProcessingErrorHandling = postRequestProcessingErrorHandling.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
