package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorHealthDetectionArgs private(
  locked: Output[Option[Boolean]],
  maximumReconnects: Output[Option[Int]],
  retryCount: Output[Option[Int]],
  retryInterval: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorHealthDetectionArgs:
  def apply(
    locked: Input.Optional[Boolean] = None,
    maximumReconnects: Input.Optional[Int] = None,
    retryCount: Input.Optional[Int] = None,
    retryInterval: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorHealthDetectionArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorHealthDetectionArgs(
      locked = locked.asOptionOutput(isSecret = false),
      maximumReconnects = maximumReconnects.asOptionOutput(isSecret = false),
      retryCount = retryCount.asOptionOutput(isSecret = false),
      retryInterval = retryInterval.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
