package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorHttpStrictTransportSecurityArgs private(
  enable: Output[Option[Boolean]],
  includeSubDomains: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  maxAge: Output[Option[String]],
  preload: Output[Option[Boolean]],
  redirect: Output[Option[Boolean]],
  redirectStatusCode: Output[Option[Int]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorHttpStrictTransportSecurityArgs:
  def apply(
    enable: Input.Optional[Boolean] = None,
    includeSubDomains: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    maxAge: Input.Optional[String] = None,
    preload: Input.Optional[Boolean] = None,
    redirect: Input.Optional[Boolean] = None,
    redirectStatusCode: Input.Optional[Int] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorHttpStrictTransportSecurityArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorHttpStrictTransportSecurityArgs(
      enable = enable.asOptionOutput(isSecret = false),
      includeSubDomains = includeSubDomains.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      maxAge = maxAge.asOptionOutput(isSecret = false),
      preload = preload.asOptionOutput(isSecret = false),
      redirect = redirect.asOptionOutput(isSecret = false),
      redirectStatusCode = redirectStatusCode.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
