package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorMPulseArgs private(
  apiKey: Output[Option[String]],
  bufferSize: Output[Option[String]],
  configOverride: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  loaderVersion: Output[Option[String]],
  locked: Output[Option[Boolean]],
  requirePci: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  titleOptional: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorMPulseArgs:
  def apply(
    apiKey: Input.Optional[String] = None,
    bufferSize: Input.Optional[String] = None,
    configOverride: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    loaderVersion: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    requirePci: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    titleOptional: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorMPulseArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorMPulseArgs(
      apiKey = apiKey.asOptionOutput(isSecret = false),
      bufferSize = bufferSize.asOptionOutput(isSecret = false),
      configOverride = configOverride.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      loaderVersion = loaderVersion.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      requirePci = requirePci.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      titleOptional = titleOptional.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
