package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorManifestPersonalizationArgs private(
  enabled: Output[Option[Boolean]],
  hlsEnableDebugHeaders: Output[Option[Boolean]],
  hlsEnabled: Output[Option[Boolean]],
  hlsFilterInBitrateRanges: Output[Option[String]],
  hlsFilterInBitrates: Output[Option[String]],
  hlsMode: Output[Option[String]],
  hlsPreferredBitrate: Output[Option[String]],
  hlsQueryParamEnabled: Output[Option[Boolean]],
  hlsQueryParamSecretKey: Output[Option[String]],
  hlsQueryParamTransitionKey: Output[Option[String]],
  hlsShowAdvanced: Output[Option[Boolean]],
  hlsTitle: Output[Option[String]],
  locked: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorManifestPersonalizationArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    hlsEnableDebugHeaders: Input.Optional[Boolean] = None,
    hlsEnabled: Input.Optional[Boolean] = None,
    hlsFilterInBitrateRanges: Input.Optional[String] = None,
    hlsFilterInBitrates: Input.Optional[String] = None,
    hlsMode: Input.Optional[String] = None,
    hlsPreferredBitrate: Input.Optional[String] = None,
    hlsQueryParamEnabled: Input.Optional[Boolean] = None,
    hlsQueryParamSecretKey: Input.Optional[String] = None,
    hlsQueryParamTransitionKey: Input.Optional[String] = None,
    hlsShowAdvanced: Input.Optional[Boolean] = None,
    hlsTitle: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorManifestPersonalizationArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorManifestPersonalizationArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      hlsEnableDebugHeaders = hlsEnableDebugHeaders.asOptionOutput(isSecret = false),
      hlsEnabled = hlsEnabled.asOptionOutput(isSecret = false),
      hlsFilterInBitrateRanges = hlsFilterInBitrateRanges.asOptionOutput(isSecret = false),
      hlsFilterInBitrates = hlsFilterInBitrates.asOptionOutput(isSecret = false),
      hlsMode = hlsMode.asOptionOutput(isSecret = false),
      hlsPreferredBitrate = hlsPreferredBitrate.asOptionOutput(isSecret = false),
      hlsQueryParamEnabled = hlsQueryParamEnabled.asOptionOutput(isSecret = false),
      hlsQueryParamSecretKey = hlsQueryParamSecretKey.asOptionOutput(isSecret = false),
      hlsQueryParamTransitionKey = hlsQueryParamTransitionKey.asOptionOutput(isSecret = false),
      hlsShowAdvanced = hlsShowAdvanced.asOptionOutput(isSecret = false),
      hlsTitle = hlsTitle.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
