package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorQualityArgs private(
  audienceSettings: Output[Option[String]],
  catalogSize: Output[Option[String]],
  contentSettings: Output[Option[String]],
  contentType: Output[Option[String]],
  country: Output[Option[String]],
  deliveryFormat: Output[Option[String]],
  deliveryType: Output[Option[String]],
  downloadType: Output[Option[String]],
  endUserLocation: Output[Option[String]],
  locked: Output[Option[Boolean]],
  maximumConcurrentUsers: Output[Option[String]],
  objectSize: Output[Option[String]],
  optimizeFor: Output[Option[String]],
  originSettings: Output[Option[String]],
  popularityDistribution: Output[Option[String]],
  refreshRate: Output[Option[String]],
  segmentDuration: Output[Option[Int]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorQualityArgs:
  def apply(
    audienceSettings: Input.Optional[String] = None,
    catalogSize: Input.Optional[String] = None,
    contentSettings: Input.Optional[String] = None,
    contentType: Input.Optional[String] = None,
    country: Input.Optional[String] = None,
    deliveryFormat: Input.Optional[String] = None,
    deliveryType: Input.Optional[String] = None,
    downloadType: Input.Optional[String] = None,
    endUserLocation: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    maximumConcurrentUsers: Input.Optional[String] = None,
    objectSize: Input.Optional[String] = None,
    optimizeFor: Input.Optional[String] = None,
    originSettings: Input.Optional[String] = None,
    popularityDistribution: Input.Optional[String] = None,
    refreshRate: Input.Optional[String] = None,
    segmentDuration: Input.Optional[Int] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorQualityArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorQualityArgs(
      audienceSettings = audienceSettings.asOptionOutput(isSecret = false),
      catalogSize = catalogSize.asOptionOutput(isSecret = false),
      contentSettings = contentSettings.asOptionOutput(isSecret = false),
      contentType = contentType.asOptionOutput(isSecret = false),
      country = country.asOptionOutput(isSecret = false),
      deliveryFormat = deliveryFormat.asOptionOutput(isSecret = false),
      deliveryType = deliveryType.asOptionOutput(isSecret = false),
      downloadType = downloadType.asOptionOutput(isSecret = false),
      endUserLocation = endUserLocation.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      maximumConcurrentUsers = maximumConcurrentUsers.asOptionOutput(isSecret = false),
      objectSize = objectSize.asOptionOutput(isSecret = false),
      optimizeFor = optimizeFor.asOptionOutput(isSecret = false),
      originSettings = originSettings.asOptionOutput(isSecret = false),
      popularityDistribution = popularityDistribution.asOptionOutput(isSecret = false),
      refreshRate = refreshRate.asOptionOutput(isSecret = false),
      segmentDuration = segmentDuration.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
