package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorRedirectArgs private(
  destinationHostname: Output[Option[String]],
  destinationHostnameOther: Output[Option[String]],
  destinationHostnameSibling: Output[Option[String]],
  destinationHostnameSubdomain: Output[Option[String]],
  destinationPath: Output[Option[String]],
  destinationPathOther: Output[Option[String]],
  destinationPathPrefix: Output[Option[String]],
  destinationPathSuffix: Output[Option[String]],
  destinationPathSuffixStatus: Output[Option[String]],
  destinationProtocol: Output[Option[String]],
  locked: Output[Option[Boolean]],
  mobileDefaultChoice: Output[Option[String]],
  queryString: Output[Option[String]],
  responseCode: Output[Option[Int]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorRedirectArgs:
  def apply(
    destinationHostname: Input.Optional[String] = None,
    destinationHostnameOther: Input.Optional[String] = None,
    destinationHostnameSibling: Input.Optional[String] = None,
    destinationHostnameSubdomain: Input.Optional[String] = None,
    destinationPath: Input.Optional[String] = None,
    destinationPathOther: Input.Optional[String] = None,
    destinationPathPrefix: Input.Optional[String] = None,
    destinationPathSuffix: Input.Optional[String] = None,
    destinationPathSuffixStatus: Input.Optional[String] = None,
    destinationProtocol: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    mobileDefaultChoice: Input.Optional[String] = None,
    queryString: Input.Optional[String] = None,
    responseCode: Input.Optional[Int] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorRedirectArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorRedirectArgs(
      destinationHostname = destinationHostname.asOptionOutput(isSecret = false),
      destinationHostnameOther = destinationHostnameOther.asOptionOutput(isSecret = false),
      destinationHostnameSibling = destinationHostnameSibling.asOptionOutput(isSecret = false),
      destinationHostnameSubdomain = destinationHostnameSubdomain.asOptionOutput(isSecret = false),
      destinationPath = destinationPath.asOptionOutput(isSecret = false),
      destinationPathOther = destinationPathOther.asOptionOutput(isSecret = false),
      destinationPathPrefix = destinationPathPrefix.asOptionOutput(isSecret = false),
      destinationPathSuffix = destinationPathSuffix.asOptionOutput(isSecret = false),
      destinationPathSuffixStatus = destinationPathSuffixStatus.asOptionOutput(isSecret = false),
      destinationProtocol = destinationProtocol.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      mobileDefaultChoice = mobileDefaultChoice.asOptionOutput(isSecret = false),
      queryString = queryString.asOptionOutput(isSecret = false),
      responseCode = responseCode.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
