package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorReportArgs private(
  cookies: Output[Option[scala.collection.immutable.List[String]]],
  customLogField: Output[Option[String]],
  locked: Output[Option[Boolean]],
  logAcceptLanguage: Output[Option[Boolean]],
  logCookies: Output[Option[String]],
  logCustomLogField: Output[Option[Boolean]],
  logEdgeIp: Output[Option[Boolean]],
  logHost: Output[Option[Boolean]],
  logReferer: Output[Option[Boolean]],
  logUserAgent: Output[Option[Boolean]],
  logXForwardedFor: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorReportArgs:
  def apply(
    cookies: Input.Optional[List[Input[String]]] = None,
    customLogField: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    logAcceptLanguage: Input.Optional[Boolean] = None,
    logCookies: Input.Optional[String] = None,
    logCustomLogField: Input.Optional[Boolean] = None,
    logEdgeIp: Input.Optional[Boolean] = None,
    logHost: Input.Optional[Boolean] = None,
    logReferer: Input.Optional[Boolean] = None,
    logUserAgent: Input.Optional[Boolean] = None,
    logXForwardedFor: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorReportArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorReportArgs(
      cookies = cookies.asOptionOutput(isSecret = false),
      customLogField = customLogField.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      logAcceptLanguage = logAcceptLanguage.asOptionOutput(isSecret = false),
      logCookies = logCookies.asOptionOutput(isSecret = false),
      logCustomLogField = logCustomLogField.asOptionOutput(isSecret = false),
      logEdgeIp = logEdgeIp.asOptionOutput(isSecret = false),
      logHost = logHost.asOptionOutput(isSecret = false),
      logReferer = logReferer.asOptionOutput(isSecret = false),
      logUserAgent = logUserAgent.asOptionOutput(isSecret = false),
      logXForwardedFor = logXForwardedFor.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
