package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorRequestControlNetStorageArgs private(
  cpCode: Output[Option[Int]],
  downloadDomainName: Output[Option[String]],
  g2oToken: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorRequestControlNetStorageArgs:
  def apply(
    cpCode: Input.Optional[Int] = None,
    downloadDomainName: Input.Optional[String] = None,
    g2oToken: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorRequestControlNetStorageArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorRequestControlNetStorageArgs(
      cpCode = cpCode.asOptionOutput(isSecret = false),
      downloadDomainName = downloadDomainName.asOptionOutput(isSecret = false),
      g2oToken = g2oToken.asOptionOutput(isSecret = false)
    )
