package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorSegmentedContentProtectionArgs private(
  acl: Output[Option[Boolean]],
  dashMediaEncryption: Output[Option[Boolean]],
  dataPayload: Output[Option[Boolean]],
  enableTokenInUri: Output[Option[Boolean]],
  enabled: Output[Option[Boolean]],
  fieldCarryOver: Output[Option[String]],
  headerForSalts: Output[Option[scala.collection.immutable.List[String]]],
  hlsMasterManifestFiles: Output[Option[scala.collection.immutable.List[String]]],
  hlsMediaEncryption: Output[Option[Boolean]],
  ip: Output[Option[Boolean]],
  key: Output[Option[String]],
  locked: Output[Option[Boolean]],
  mediaEncryptionTitle: Output[Option[String]],
  revokedListId: Output[Option[Int]],
  salt: Output[Option[String]],
  sessionId: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  tokenAuthHlsTitle: Output[Option[String]],
  tokenAuthenticationTitle: Output[Option[String]],
  tokenRevocationEnabled: Output[Option[Boolean]],
  tokenRevocationTitle: Output[Option[String]],
  transitionKey: Output[Option[String]],
  useAdvanced: Output[Option[Boolean]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorSegmentedContentProtectionArgs:
  def apply(
    acl: Input.Optional[Boolean] = None,
    dashMediaEncryption: Input.Optional[Boolean] = None,
    dataPayload: Input.Optional[Boolean] = None,
    enableTokenInUri: Input.Optional[Boolean] = None,
    enabled: Input.Optional[Boolean] = None,
    fieldCarryOver: Input.Optional[String] = None,
    headerForSalts: Input.Optional[List[Input[String]]] = None,
    hlsMasterManifestFiles: Input.Optional[List[Input[String]]] = None,
    hlsMediaEncryption: Input.Optional[Boolean] = None,
    ip: Input.Optional[Boolean] = None,
    key: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    mediaEncryptionTitle: Input.Optional[String] = None,
    revokedListId: Input.Optional[Int] = None,
    salt: Input.Optional[String] = None,
    sessionId: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    tokenAuthHlsTitle: Input.Optional[String] = None,
    tokenAuthenticationTitle: Input.Optional[String] = None,
    tokenRevocationEnabled: Input.Optional[Boolean] = None,
    tokenRevocationTitle: Input.Optional[String] = None,
    transitionKey: Input.Optional[String] = None,
    useAdvanced: Input.Optional[Boolean] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorSegmentedContentProtectionArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorSegmentedContentProtectionArgs(
      acl = acl.asOptionOutput(isSecret = false),
      dashMediaEncryption = dashMediaEncryption.asOptionOutput(isSecret = false),
      dataPayload = dataPayload.asOptionOutput(isSecret = false),
      enableTokenInUri = enableTokenInUri.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      fieldCarryOver = fieldCarryOver.asOptionOutput(isSecret = false),
      headerForSalts = headerForSalts.asOptionOutput(isSecret = false),
      hlsMasterManifestFiles = hlsMasterManifestFiles.asOptionOutput(isSecret = false),
      hlsMediaEncryption = hlsMediaEncryption.asOptionOutput(isSecret = false),
      ip = ip.asOptionOutput(isSecret = false),
      key = key.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      mediaEncryptionTitle = mediaEncryptionTitle.asOptionOutput(isSecret = false),
      revokedListId = revokedListId.asOptionOutput(isSecret = false),
      salt = salt.asOptionOutput(isSecret = false),
      sessionId = sessionId.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      tokenAuthHlsTitle = tokenAuthHlsTitle.asOptionOutput(isSecret = false),
      tokenAuthenticationTitle = tokenAuthenticationTitle.asOptionOutput(isSecret = false),
      tokenRevocationEnabled = tokenRevocationEnabled.asOptionOutput(isSecret = false),
      tokenRevocationTitle = tokenRevocationTitle.asOptionOutput(isSecret = false),
      transitionKey = transitionKey.asOptionOutput(isSecret = false),
      useAdvanced = useAdvanced.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
