package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorStandardTlsMigrationArgs private(
  allowHttpsDowngrade: Output[Option[Boolean]],
  allowHttpsUpgrade: Output[Option[Boolean]],
  cacheSharingDuration: Output[Option[Int]],
  cacheSharingStartTime: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  isCertificateSniOnly: Output[Option[Boolean]],
  isTieredDistributionUsed: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  migrationDuration: Output[Option[Int]],
  migrationFrom: Output[Option[String]],
  migrationStartTime: Output[Option[String]],
  tdLocation: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorStandardTlsMigrationArgs:
  def apply(
    allowHttpsDowngrade: Input.Optional[Boolean] = None,
    allowHttpsUpgrade: Input.Optional[Boolean] = None,
    cacheSharingDuration: Input.Optional[Int] = None,
    cacheSharingStartTime: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    isCertificateSniOnly: Input.Optional[Boolean] = None,
    isTieredDistributionUsed: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    migrationDuration: Input.Optional[Int] = None,
    migrationFrom: Input.Optional[String] = None,
    migrationStartTime: Input.Optional[String] = None,
    tdLocation: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorStandardTlsMigrationArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorStandardTlsMigrationArgs(
      allowHttpsDowngrade = allowHttpsDowngrade.asOptionOutput(isSecret = false),
      allowHttpsUpgrade = allowHttpsUpgrade.asOptionOutput(isSecret = false),
      cacheSharingDuration = cacheSharingDuration.asOptionOutput(isSecret = false),
      cacheSharingStartTime = cacheSharingStartTime.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      isCertificateSniOnly = isCertificateSniOnly.asOptionOutput(isSecret = false),
      isTieredDistributionUsed = isTieredDistributionUsed.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      migrationDuration = migrationDuration.asOptionOutput(isSecret = false),
      migrationFrom = migrationFrom.asOptionOutput(isSecret = false),
      migrationStartTime = migrationStartTime.asOptionOutput(isSecret = false),
      tdLocation = tdLocation.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
