package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorUidConfigurationArgs private(
  enabled: Output[Option[Boolean]],
  extractLocation: Output[Option[String]],
  headerName: Output[Option[String]],
  legalText: Output[Option[String]],
  locked: Output[Option[Boolean]],
  queryParameterName: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]],
  variableName: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorUidConfigurationArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    extractLocation: Input.Optional[String] = None,
    headerName: Input.Optional[String] = None,
    legalText: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    queryParameterName: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None,
    variableName: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorUidConfigurationArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorUidConfigurationArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      extractLocation = extractLocation.asOptionOutput(isSecret = false),
      headerName = headerName.asOptionOutput(isSecret = false),
      legalText = legalText.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      queryParameterName = queryParameterName.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false),
      variableName = variableName.asOptionOutput(isSecret = false)
    )
