package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105BehaviorVerifyTokenAuthorizationArgs private(
  algorithm: Output[Option[String]],
  escapeHmacInputs: Output[Option[Boolean]],
  failureResponse: Output[Option[Boolean]],
  ignoreQueryString: Output[Option[Boolean]],
  key: Output[Option[String]],
  location: Output[Option[String]],
  locationId: Output[Option[String]],
  locked: Output[Option[Boolean]],
  salt: Output[Option[String]],
  templateUuid: Output[Option[String]],
  transitionKey: Output[Option[String]],
  useAdvanced: Output[Option[Boolean]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105BehaviorVerifyTokenAuthorizationArgs:
  def apply(
    algorithm: Input.Optional[String] = None,
    escapeHmacInputs: Input.Optional[Boolean] = None,
    failureResponse: Input.Optional[Boolean] = None,
    ignoreQueryString: Input.Optional[Boolean] = None,
    key: Input.Optional[String] = None,
    location: Input.Optional[String] = None,
    locationId: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    salt: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    transitionKey: Input.Optional[String] = None,
    useAdvanced: Input.Optional[Boolean] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105BehaviorVerifyTokenAuthorizationArgs =
    new GetPropertyRulesBuilderRulesV20230105BehaviorVerifyTokenAuthorizationArgs(
      algorithm = algorithm.asOptionOutput(isSecret = false),
      escapeHmacInputs = escapeHmacInputs.asOptionOutput(isSecret = false),
      failureResponse = failureResponse.asOptionOutput(isSecret = false),
      ignoreQueryString = ignoreQueryString.asOptionOutput(isSecret = false),
      key = key.asOptionOutput(isSecret = false),
      location = location.asOptionOutput(isSecret = false),
      locationId = locationId.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      salt = salt.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      transitionKey = transitionKey.asOptionOutput(isSecret = false),
      useAdvanced = useAdvanced.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
