package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230105CriterionRequestCookieArgs private(
  cookieName: Output[Option[String]],
  locked: Output[Option[Boolean]],
  lowerBound: Output[Option[Int]],
  matchCaseSensitiveName: Output[Option[Boolean]],
  matchCaseSensitiveValue: Output[Option[Boolean]],
  matchOperator: Output[Option[String]],
  matchWildcardName: Output[Option[Boolean]],
  matchWildcardValue: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  upperBound: Output[Option[Int]],
  uuid: Output[Option[String]],
  value: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230105CriterionRequestCookieArgs:
  def apply(
    cookieName: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    lowerBound: Input.Optional[Int] = None,
    matchCaseSensitiveName: Input.Optional[Boolean] = None,
    matchCaseSensitiveValue: Input.Optional[Boolean] = None,
    matchOperator: Input.Optional[String] = None,
    matchWildcardName: Input.Optional[Boolean] = None,
    matchWildcardValue: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    upperBound: Input.Optional[Int] = None,
    uuid: Input.Optional[String] = None,
    value: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230105CriterionRequestCookieArgs =
    new GetPropertyRulesBuilderRulesV20230105CriterionRequestCookieArgs(
      cookieName = cookieName.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      lowerBound = lowerBound.asOptionOutput(isSecret = false),
      matchCaseSensitiveName = matchCaseSensitiveName.asOptionOutput(isSecret = false),
      matchCaseSensitiveValue = matchCaseSensitiveValue.asOptionOutput(isSecret = false),
      matchOperator = matchOperator.asOptionOutput(isSecret = false),
      matchWildcardName = matchWildcardName.asOptionOutput(isSecret = false),
      matchWildcardValue = matchWildcardValue.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      upperBound = upperBound.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false),
      value = value.asOptionOutput(isSecret = false)
    )
