package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorCacheErrorArgs private(
  enabled: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  preserveStale: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  ttl: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorCacheErrorArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    preserveStale: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    ttl: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorCacheErrorArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorCacheErrorArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      preserveStale = preserveStale.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      ttl = ttl.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
