package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorCachingArgs private(
  behavior: Output[Option[String]],
  cacheControlDirectives: Output[Option[String]],
  cacheabilitySettings: Output[Option[String]],
  defaultTtl: Output[Option[String]],
  enhancedRfcSupport: Output[Option[Boolean]],
  expirationSettings: Output[Option[String]],
  honorMaxAge: Output[Option[Boolean]],
  honorMustRevalidate: Output[Option[Boolean]],
  honorNoCache: Output[Option[Boolean]],
  honorNoStore: Output[Option[Boolean]],
  honorPrivate: Output[Option[Boolean]],
  honorProxyRevalidate: Output[Option[Boolean]],
  honorSMaxage: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  mustRevalidate: Output[Option[Boolean]],
  revalidationSettings: Output[Option[String]],
  templateUuid: Output[Option[String]],
  ttl: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorCachingArgs:
  def apply(
    behavior: Input.Optional[String] = None,
    cacheControlDirectives: Input.Optional[String] = None,
    cacheabilitySettings: Input.Optional[String] = None,
    defaultTtl: Input.Optional[String] = None,
    enhancedRfcSupport: Input.Optional[Boolean] = None,
    expirationSettings: Input.Optional[String] = None,
    honorMaxAge: Input.Optional[Boolean] = None,
    honorMustRevalidate: Input.Optional[Boolean] = None,
    honorNoCache: Input.Optional[Boolean] = None,
    honorNoStore: Input.Optional[Boolean] = None,
    honorPrivate: Input.Optional[Boolean] = None,
    honorProxyRevalidate: Input.Optional[Boolean] = None,
    honorSMaxage: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    mustRevalidate: Input.Optional[Boolean] = None,
    revalidationSettings: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    ttl: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorCachingArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorCachingArgs(
      behavior = behavior.asOptionOutput(isSecret = false),
      cacheControlDirectives = cacheControlDirectives.asOptionOutput(isSecret = false),
      cacheabilitySettings = cacheabilitySettings.asOptionOutput(isSecret = false),
      defaultTtl = defaultTtl.asOptionOutput(isSecret = false),
      enhancedRfcSupport = enhancedRfcSupport.asOptionOutput(isSecret = false),
      expirationSettings = expirationSettings.asOptionOutput(isSecret = false),
      honorMaxAge = honorMaxAge.asOptionOutput(isSecret = false),
      honorMustRevalidate = honorMustRevalidate.asOptionOutput(isSecret = false),
      honorNoCache = honorNoCache.asOptionOutput(isSecret = false),
      honorNoStore = honorNoStore.asOptionOutput(isSecret = false),
      honorPrivate = honorPrivate.asOptionOutput(isSecret = false),
      honorProxyRevalidate = honorProxyRevalidate.asOptionOutput(isSecret = false),
      honorSMaxage = honorSMaxage.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      mustRevalidate = mustRevalidate.asOptionOutput(isSecret = false),
      revalidationSettings = revalidationSettings.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      ttl = ttl.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
