package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorContentCharacteristicsWsdLiveArgs private(
  catalogSize: Output[Option[String]],
  contentType: Output[Option[String]],
  dash: Output[Option[Boolean]],
  hds: Output[Option[Boolean]],
  hls: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  popularityDistribution: Output[Option[String]],
  segmentDurationDash: Output[Option[String]],
  segmentDurationHds: Output[Option[String]],
  segmentDurationHls: Output[Option[String]],
  segmentDurationSmooth: Output[Option[String]],
  segmentSizeDash: Output[Option[String]],
  segmentSizeHds: Output[Option[String]],
  segmentSizeHls: Output[Option[String]],
  segmentSizeSmooth: Output[Option[String]],
  smooth: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorContentCharacteristicsWsdLiveArgs:
  def apply(
    catalogSize: Input.Optional[String] = None,
    contentType: Input.Optional[String] = None,
    dash: Input.Optional[Boolean] = None,
    hds: Input.Optional[Boolean] = None,
    hls: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    popularityDistribution: Input.Optional[String] = None,
    segmentDurationDash: Input.Optional[String] = None,
    segmentDurationHds: Input.Optional[String] = None,
    segmentDurationHls: Input.Optional[String] = None,
    segmentDurationSmooth: Input.Optional[String] = None,
    segmentSizeDash: Input.Optional[String] = None,
    segmentSizeHds: Input.Optional[String] = None,
    segmentSizeHls: Input.Optional[String] = None,
    segmentSizeSmooth: Input.Optional[String] = None,
    smooth: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorContentCharacteristicsWsdLiveArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorContentCharacteristicsWsdLiveArgs(
      catalogSize = catalogSize.asOptionOutput(isSecret = false),
      contentType = contentType.asOptionOutput(isSecret = false),
      dash = dash.asOptionOutput(isSecret = false),
      hds = hds.asOptionOutput(isSecret = false),
      hls = hls.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      popularityDistribution = popularityDistribution.asOptionOutput(isSecret = false),
      segmentDurationDash = segmentDurationDash.asOptionOutput(isSecret = false),
      segmentDurationHds = segmentDurationHds.asOptionOutput(isSecret = false),
      segmentDurationHls = segmentDurationHls.asOptionOutput(isSecret = false),
      segmentDurationSmooth = segmentDurationSmooth.asOptionOutput(isSecret = false),
      segmentSizeDash = segmentSizeDash.asOptionOutput(isSecret = false),
      segmentSizeHds = segmentSizeHds.asOptionOutput(isSecret = false),
      segmentSizeHls = segmentSizeHls.asOptionOutput(isSecret = false),
      segmentSizeSmooth = segmentSizeSmooth.asOptionOutput(isSecret = false),
      smooth = smooth.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
