package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorContentTargetingProtectionArgs private(
  countries: Output[Option[scala.collection.immutable.List[String]]],
  dmas: Output[Option[scala.collection.immutable.List[String]]],
  enableGeoProtection: Output[Option[Boolean]],
  enableGeoRedirectOnDeny: Output[Option[Boolean]],
  enableIpProtection: Output[Option[Boolean]],
  enableIpRedirectOnDeny: Output[Option[Boolean]],
  enableReferrerProtection: Output[Option[Boolean]],
  enableReferrerRedirectOnDeny: Output[Option[Boolean]],
  enabled: Output[Option[Boolean]],
  geoProtectionMode: Output[Option[String]],
  geoProtectionTitle: Output[Option[String]],
  geoRedirectUrl: Output[Option[String]],
  ipAddresses: Output[Option[scala.collection.immutable.List[String]]],
  ipProtectionMode: Output[Option[String]],
  ipProtectionTitle: Output[Option[String]],
  ipRedirectUrl: Output[Option[String]],
  locked: Output[Option[Boolean]],
  overrideIpAddresses: Output[Option[scala.collection.immutable.List[String]]],
  referrerDomains: Output[Option[scala.collection.immutable.List[String]]],
  referrerProtectionMode: Output[Option[String]],
  referrerProtectionTitle: Output[Option[String]],
  referrerRedirectUrl: Output[Option[String]],
  regions: Output[Option[scala.collection.immutable.List[String]]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorContentTargetingProtectionArgs:
  def apply(
    countries: Input.Optional[List[Input[String]]] = None,
    dmas: Input.Optional[List[Input[String]]] = None,
    enableGeoProtection: Input.Optional[Boolean] = None,
    enableGeoRedirectOnDeny: Input.Optional[Boolean] = None,
    enableIpProtection: Input.Optional[Boolean] = None,
    enableIpRedirectOnDeny: Input.Optional[Boolean] = None,
    enableReferrerProtection: Input.Optional[Boolean] = None,
    enableReferrerRedirectOnDeny: Input.Optional[Boolean] = None,
    enabled: Input.Optional[Boolean] = None,
    geoProtectionMode: Input.Optional[String] = None,
    geoProtectionTitle: Input.Optional[String] = None,
    geoRedirectUrl: Input.Optional[String] = None,
    ipAddresses: Input.Optional[List[Input[String]]] = None,
    ipProtectionMode: Input.Optional[String] = None,
    ipProtectionTitle: Input.Optional[String] = None,
    ipRedirectUrl: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    overrideIpAddresses: Input.Optional[List[Input[String]]] = None,
    referrerDomains: Input.Optional[List[Input[String]]] = None,
    referrerProtectionMode: Input.Optional[String] = None,
    referrerProtectionTitle: Input.Optional[String] = None,
    referrerRedirectUrl: Input.Optional[String] = None,
    regions: Input.Optional[List[Input[String]]] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorContentTargetingProtectionArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorContentTargetingProtectionArgs(
      countries = countries.asOptionOutput(isSecret = false),
      dmas = dmas.asOptionOutput(isSecret = false),
      enableGeoProtection = enableGeoProtection.asOptionOutput(isSecret = false),
      enableGeoRedirectOnDeny = enableGeoRedirectOnDeny.asOptionOutput(isSecret = false),
      enableIpProtection = enableIpProtection.asOptionOutput(isSecret = false),
      enableIpRedirectOnDeny = enableIpRedirectOnDeny.asOptionOutput(isSecret = false),
      enableReferrerProtection = enableReferrerProtection.asOptionOutput(isSecret = false),
      enableReferrerRedirectOnDeny = enableReferrerRedirectOnDeny.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      geoProtectionMode = geoProtectionMode.asOptionOutput(isSecret = false),
      geoProtectionTitle = geoProtectionTitle.asOptionOutput(isSecret = false),
      geoRedirectUrl = geoRedirectUrl.asOptionOutput(isSecret = false),
      ipAddresses = ipAddresses.asOptionOutput(isSecret = false),
      ipProtectionMode = ipProtectionMode.asOptionOutput(isSecret = false),
      ipProtectionTitle = ipProtectionTitle.asOptionOutput(isSecret = false),
      ipRedirectUrl = ipRedirectUrl.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      overrideIpAddresses = overrideIpAddresses.asOptionOutput(isSecret = false),
      referrerDomains = referrerDomains.asOptionOutput(isSecret = false),
      referrerProtectionMode = referrerProtectionMode.asOptionOutput(isSecret = false),
      referrerProtectionTitle = referrerProtectionTitle.asOptionOutput(isSecret = false),
      referrerRedirectUrl = referrerRedirectUrl.asOptionOutput(isSecret = false),
      regions = regions.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
