package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorCorsSupportArgs private(
  allowCredentials: Output[Option[Boolean]],
  allowHeaders: Output[Option[String]],
  allowOrigins: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  exposeHeaders: Output[Option[scala.collection.immutable.List[String]]],
  headers: Output[Option[scala.collection.immutable.List[String]]],
  locked: Output[Option[Boolean]],
  methods: Output[Option[scala.collection.immutable.List[String]]],
  origins: Output[Option[scala.collection.immutable.List[String]]],
  preflightMaxAge: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorCorsSupportArgs:
  def apply(
    allowCredentials: Input.Optional[Boolean] = None,
    allowHeaders: Input.Optional[String] = None,
    allowOrigins: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    exposeHeaders: Input.Optional[List[Input[String]]] = None,
    headers: Input.Optional[List[Input[String]]] = None,
    locked: Input.Optional[Boolean] = None,
    methods: Input.Optional[List[Input[String]]] = None,
    origins: Input.Optional[List[Input[String]]] = None,
    preflightMaxAge: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorCorsSupportArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorCorsSupportArgs(
      allowCredentials = allowCredentials.asOptionOutput(isSecret = false),
      allowHeaders = allowHeaders.asOptionOutput(isSecret = false),
      allowOrigins = allowOrigins.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      exposeHeaders = exposeHeaders.asOptionOutput(isSecret = false),
      headers = headers.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      methods = methods.asOptionOutput(isSecret = false),
      origins = origins.asOptionOutput(isSecret = false),
      preflightMaxAge = preflightMaxAge.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
