package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorDatastreamArgs private(
  beaconStreamTitle: Output[Option[String]],
  collectMidgressTraffic: Output[Option[Boolean]],
  datastreamIds: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  logEnabled: Output[Option[Boolean]],
  logStreamNames: Output[Option[scala.collection.immutable.List[String]]],
  logStreamTitle: Output[Option[String]],
  samplingPercentage: Output[Option[Int]],
  streamType: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorDatastreamArgs:
  def apply(
    beaconStreamTitle: Input.Optional[String] = None,
    collectMidgressTraffic: Input.Optional[Boolean] = None,
    datastreamIds: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    logEnabled: Input.Optional[Boolean] = None,
    logStreamNames: Input.Optional[List[Input[String]]] = None,
    logStreamTitle: Input.Optional[String] = None,
    samplingPercentage: Input.Optional[Int] = None,
    streamType: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorDatastreamArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorDatastreamArgs(
      beaconStreamTitle = beaconStreamTitle.asOptionOutput(isSecret = false),
      collectMidgressTraffic = collectMidgressTraffic.asOptionOutput(isSecret = false),
      datastreamIds = datastreamIds.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      logEnabled = logEnabled.asOptionOutput(isSecret = false),
      logStreamNames = logStreamNames.asOptionOutput(isSecret = false),
      logStreamTitle = logStreamTitle.asOptionOutput(isSecret = false),
      samplingPercentage = samplingPercentage.asOptionOutput(isSecret = false),
      streamType = streamType.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
