package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorDcpRealTimeAuthArgs private(
  extractHostname: Output[Option[Boolean]],
  extractJurisdiction: Output[Option[Boolean]],
  extractNamespace: Output[Option[Boolean]],
  hostnameClaim: Output[Option[String]],
  jurisdictionClaim: Output[Option[String]],
  locked: Output[Option[Boolean]],
  namespaceClaim: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorDcpRealTimeAuthArgs:
  def apply(
    extractHostname: Input.Optional[Boolean] = None,
    extractJurisdiction: Input.Optional[Boolean] = None,
    extractNamespace: Input.Optional[Boolean] = None,
    hostnameClaim: Input.Optional[String] = None,
    jurisdictionClaim: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    namespaceClaim: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorDcpRealTimeAuthArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorDcpRealTimeAuthArgs(
      extractHostname = extractHostname.asOptionOutput(isSecret = false),
      extractJurisdiction = extractJurisdiction.asOptionOutput(isSecret = false),
      extractNamespace = extractNamespace.asOptionOutput(isSecret = false),
      hostnameClaim = hostnameClaim.asOptionOutput(isSecret = false),
      jurisdictionClaim = jurisdictionClaim.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      namespaceClaim = namespaceClaim.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
