package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCacheArgs private(
  allowBehavior: Output[Option[String]],
  behavior: Output[Option[String]],
  locked: Output[Option[Boolean]],
  sendHeaders: Output[Option[String]],
  sendPrivate: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  ttl: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCacheArgs:
  def apply(
    allowBehavior: Input.Optional[String] = None,
    behavior: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    sendHeaders: Input.Optional[String] = None,
    sendPrivate: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    ttl: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCacheArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCacheArgs(
      allowBehavior = allowBehavior.asOptionOutput(isSecret = false),
      behavior = behavior.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      sendHeaders = sendHeaders.asOptionOutput(isSecret = false),
      sendPrivate = sendPrivate.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      ttl = ttl.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
