package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorEdgeConnectArgs private(
  aggregateLines: Output[Option[String]],
  aggregateSize: Output[Option[String]],
  aggregateTime: Output[Option[String]],
  apiConnector: Output[Option[String]],
  apiDataElements: Output[Option[scala.collection.immutable.List[String]]],
  destinationHostname: Output[Option[String]],
  destinationPath: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  overrideAggregateSettings: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorEdgeConnectArgs:
  def apply(
    aggregateLines: Input.Optional[String] = None,
    aggregateSize: Input.Optional[String] = None,
    aggregateTime: Input.Optional[String] = None,
    apiConnector: Input.Optional[String] = None,
    apiDataElements: Input.Optional[List[Input[String]]] = None,
    destinationHostname: Input.Optional[String] = None,
    destinationPath: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    overrideAggregateSettings: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorEdgeConnectArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorEdgeConnectArgs(
      aggregateLines = aggregateLines.asOptionOutput(isSecret = false),
      aggregateSize = aggregateSize.asOptionOutput(isSecret = false),
      aggregateTime = aggregateTime.asOptionOutput(isSecret = false),
      apiConnector = apiConnector.asOptionOutput(isSecret = false),
      apiDataElements = apiDataElements.asOptionOutput(isSecret = false),
      destinationHostname = destinationHostname.asOptionOutput(isSecret = false),
      destinationPath = destinationPath.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      overrideAggregateSettings = overrideAggregateSettings.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
