package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorMediaClientArgs private(
  beaconId: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  useHybridHttpUdp: Output[Option[Boolean]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorMediaClientArgs:
  def apply(
    beaconId: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    useHybridHttpUdp: Input.Optional[Boolean] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorMediaClientArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorMediaClientArgs(
      beaconId = beaconId.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      useHybridHttpUdp = useHybridHttpUdp.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
