package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristicsArgs private(
  accessKeyEncryptedStorage: Output[Option[Boolean]],
  adcTitle: Output[Option[String]],
  authenticationMethod: Output[Option[String]],
  authenticationMethodTitle: Output[Option[String]],
  awsAccessKeyId: Output[Option[String]],
  awsAccessKeyVersionGuid: Output[Option[String]],
  awsArRegion: Output[Option[String]],
  awsHost: Output[Option[String]],
  awsRegion: Output[Option[String]],
  awsSecretAccessKey: Output[Option[String]],
  awsService: Output[Option[String]],
  country: Output[Option[String]],
  customSignStrings: Output[Option[scala.collection.immutable.List[String]]],
  directConnectGeo: Output[Option[String]],
  encodingVersion: Output[Option[Int]],
  endPointService: Output[Option[String]],
  gcsAccessKeyVersionGuid: Output[Option[String]],
  gcsHmacKeyAccessId: Output[Option[String]],
  gcsHmacKeySecret: Output[Option[String]],
  hostnameTag: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  mslkey: Output[Option[String]],
  mslname: Output[Option[String]],
  nonce: Output[Option[String]],
  originLocationTitle: Output[Option[String]],
  propertyIdTag: Output[Option[Boolean]],
  roleArn: Output[Option[String]],
  secretKey: Output[Option[String]],
  templateUuid: Output[Option[String]],
  useCustomSignString: Output[Option[Boolean]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristicsArgs:
  def apply(
    accessKeyEncryptedStorage: Input.Optional[Boolean] = None,
    adcTitle: Input.Optional[String] = None,
    authenticationMethod: Input.Optional[String] = None,
    authenticationMethodTitle: Input.Optional[String] = None,
    awsAccessKeyId: Input.Optional[String] = None,
    awsAccessKeyVersionGuid: Input.Optional[String] = None,
    awsArRegion: Input.Optional[String] = None,
    awsHost: Input.Optional[String] = None,
    awsRegion: Input.Optional[String] = None,
    awsSecretAccessKey: Input.Optional[String] = None,
    awsService: Input.Optional[String] = None,
    country: Input.Optional[String] = None,
    customSignStrings: Input.Optional[List[Input[String]]] = None,
    directConnectGeo: Input.Optional[String] = None,
    encodingVersion: Input.Optional[Int] = None,
    endPointService: Input.Optional[String] = None,
    gcsAccessKeyVersionGuid: Input.Optional[String] = None,
    gcsHmacKeyAccessId: Input.Optional[String] = None,
    gcsHmacKeySecret: Input.Optional[String] = None,
    hostnameTag: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    mslkey: Input.Optional[String] = None,
    mslname: Input.Optional[String] = None,
    nonce: Input.Optional[String] = None,
    originLocationTitle: Input.Optional[String] = None,
    propertyIdTag: Input.Optional[Boolean] = None,
    roleArn: Input.Optional[String] = None,
    secretKey: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    useCustomSignString: Input.Optional[Boolean] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristicsArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristicsArgs(
      accessKeyEncryptedStorage = accessKeyEncryptedStorage.asOptionOutput(isSecret = false),
      adcTitle = adcTitle.asOptionOutput(isSecret = false),
      authenticationMethod = authenticationMethod.asOptionOutput(isSecret = false),
      authenticationMethodTitle = authenticationMethodTitle.asOptionOutput(isSecret = false),
      awsAccessKeyId = awsAccessKeyId.asOptionOutput(isSecret = false),
      awsAccessKeyVersionGuid = awsAccessKeyVersionGuid.asOptionOutput(isSecret = false),
      awsArRegion = awsArRegion.asOptionOutput(isSecret = false),
      awsHost = awsHost.asOptionOutput(isSecret = false),
      awsRegion = awsRegion.asOptionOutput(isSecret = false),
      awsSecretAccessKey = awsSecretAccessKey.asOptionOutput(isSecret = false),
      awsService = awsService.asOptionOutput(isSecret = false),
      country = country.asOptionOutput(isSecret = false),
      customSignStrings = customSignStrings.asOptionOutput(isSecret = false),
      directConnectGeo = directConnectGeo.asOptionOutput(isSecret = false),
      encodingVersion = encodingVersion.asOptionOutput(isSecret = false),
      endPointService = endPointService.asOptionOutput(isSecret = false),
      gcsAccessKeyVersionGuid = gcsAccessKeyVersionGuid.asOptionOutput(isSecret = false),
      gcsHmacKeyAccessId = gcsHmacKeyAccessId.asOptionOutput(isSecret = false),
      gcsHmacKeySecret = gcsHmacKeySecret.asOptionOutput(isSecret = false),
      hostnameTag = hostnameTag.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      mslkey = mslkey.asOptionOutput(isSecret = false),
      mslname = mslname.asOptionOutput(isSecret = false),
      nonce = nonce.asOptionOutput(isSecret = false),
      originLocationTitle = originLocationTitle.asOptionOutput(isSecret = false),
      propertyIdTag = propertyIdTag.asOptionOutput(isSecret = false),
      roleArn = roleArn.asOptionOutput(isSecret = false),
      secretKey = secretKey.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      useCustomSignString = useCustomSignString.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
