package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorOriginCustomCertificateAuthorityArgs private(
  pemEncodedCert: Output[Option[String]],
  sha1Fingerprint: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorOriginCustomCertificateAuthorityArgs:
  def apply(
    pemEncodedCert: Input.Optional[String] = None,
    sha1Fingerprint: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorOriginCustomCertificateAuthorityArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorOriginCustomCertificateAuthorityArgs(
      pemEncodedCert = pemEncodedCert.asOptionOutput(isSecret = false),
      sha1Fingerprint = sha1Fingerprint.asOptionOutput(isSecret = false)
    )
