package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorResponseCookieArgs private(
  cookieName: Output[Option[String]],
  defaultDomain: Output[Option[Boolean]],
  defaultPath: Output[Option[Boolean]],
  domain: Output[Option[String]],
  duration: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  expirationDate: Output[Option[String]],
  expires: Output[Option[String]],
  format: Output[Option[String]],
  httpOnly: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  path: Output[Option[String]],
  sameSite: Output[Option[String]],
  secure: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  `type`: Output[Option[String]],
  uuid: Output[Option[String]],
  value: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorResponseCookieArgs:
  def apply(
    cookieName: Input.Optional[String] = None,
    defaultDomain: Input.Optional[Boolean] = None,
    defaultPath: Input.Optional[Boolean] = None,
    domain: Input.Optional[String] = None,
    duration: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    expirationDate: Input.Optional[String] = None,
    expires: Input.Optional[String] = None,
    format: Input.Optional[String] = None,
    httpOnly: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    path: Input.Optional[String] = None,
    sameSite: Input.Optional[String] = None,
    secure: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    `type`: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None,
    value: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorResponseCookieArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorResponseCookieArgs(
      cookieName = cookieName.asOptionOutput(isSecret = false),
      defaultDomain = defaultDomain.asOptionOutput(isSecret = false),
      defaultPath = defaultPath.asOptionOutput(isSecret = false),
      domain = domain.asOptionOutput(isSecret = false),
      duration = duration.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      expirationDate = expirationDate.asOptionOutput(isSecret = false),
      expires = expires.asOptionOutput(isSecret = false),
      format = format.asOptionOutput(isSecret = false),
      httpOnly = httpOnly.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      path = path.asOptionOutput(isSecret = false),
      sameSite = sameSite.asOptionOutput(isSecret = false),
      secure = secure.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      `type` = `type`.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false),
      value = value.asOptionOutput(isSecret = false)
    )
