package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorRewriteUrlArgs private(
  behavior: Output[Option[String]],
  keepQueryString: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  `match`: Output[Option[String]],
  matchMultiple: Output[Option[Boolean]],
  matchRegex: Output[Option[String]],
  targetPath: Output[Option[String]],
  targetPathPrepend: Output[Option[String]],
  targetRegex: Output[Option[String]],
  targetUrl: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorRewriteUrlArgs:
  def apply(
    behavior: Input.Optional[String] = None,
    keepQueryString: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    `match`: Input.Optional[String] = None,
    matchMultiple: Input.Optional[Boolean] = None,
    matchRegex: Input.Optional[String] = None,
    targetPath: Input.Optional[String] = None,
    targetPathPrepend: Input.Optional[String] = None,
    targetRegex: Input.Optional[String] = None,
    targetUrl: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorRewriteUrlArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorRewriteUrlArgs(
      behavior = behavior.asOptionOutput(isSecret = false),
      keepQueryString = keepQueryString.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      `match` = `match`.asOptionOutput(isSecret = false),
      matchMultiple = matchMultiple.asOptionOutput(isSecret = false),
      matchRegex = matchRegex.asOptionOutput(isSecret = false),
      targetPath = targetPath.asOptionOutput(isSecret = false),
      targetPathPrepend = targetPathPrepend.asOptionOutput(isSecret = false),
      targetRegex = targetRegex.asOptionOutput(isSecret = false),
      targetUrl = targetUrl.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
