package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorScriptManagementArgs private(
  enabled: Output[Option[Boolean]],
  locked: Output[Option[Boolean]],
  serviceworker: Output[Option[String]],
  templateUuid: Output[Option[String]],
  timestamp: Output[Option[Int]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorScriptManagementArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    locked: Input.Optional[Boolean] = None,
    serviceworker: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    timestamp: Input.Optional[Int] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorScriptManagementArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorScriptManagementArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      serviceworker = serviceworker.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      timestamp = timestamp.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
