package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorSegmentedMediaOptimizationArgs private(
  behavior: Output[Option[String]],
  dvrType: Output[Option[String]],
  dvrWindow: Output[Option[String]],
  enableUllStreaming: Output[Option[Boolean]],
  endTime: Output[Option[String]],
  liveType: Output[Option[String]],
  locked: Output[Option[Boolean]],
  showAdvanced: Output[Option[Boolean]],
  startTime: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorSegmentedMediaOptimizationArgs:
  def apply(
    behavior: Input.Optional[String] = None,
    dvrType: Input.Optional[String] = None,
    dvrWindow: Input.Optional[String] = None,
    enableUllStreaming: Input.Optional[Boolean] = None,
    endTime: Input.Optional[String] = None,
    liveType: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    showAdvanced: Input.Optional[Boolean] = None,
    startTime: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorSegmentedMediaOptimizationArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorSegmentedMediaOptimizationArgs(
      behavior = behavior.asOptionOutput(isSecret = false),
      dvrType = dvrType.asOptionOutput(isSecret = false),
      dvrWindow = dvrWindow.asOptionOutput(isSecret = false),
      enableUllStreaming = enableUllStreaming.asOptionOutput(isSecret = false),
      endTime = endTime.asOptionOutput(isSecret = false),
      liveType = liveType.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      showAdvanced = showAdvanced.asOptionOutput(isSecret = false),
      startTime = startTime.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
