package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorSetVariableArgs private(
  algorithm: Output[Option[String]],
  caseSensitive: Output[Option[Boolean]],
  certificateFieldName: Output[Option[String]],
  cookieName: Output[Option[String]],
  deviceProfile: Output[Option[String]],
  encryptionKey: Output[Option[String]],
  encryptionMode: Output[Option[String]],
  endIndex: Output[Option[String]],
  exceptChars: Output[Option[String]],
  extractLocation: Output[Option[String]],
  forceChars: Output[Option[String]],
  formatString: Output[Option[String]],
  generator: Output[Option[String]],
  globalSubstitution: Output[Option[Boolean]],
  headerName: Output[Option[String]],
  hmacAlgorithm: Output[Option[String]],
  hmacKey: Output[Option[String]],
  initializationVector: Output[Option[String]],
  ipVersion: Output[Option[String]],
  ipv4Prefix: Output[Option[Int]],
  ipv6Prefix: Output[Option[Int]],
  locationId: Output[Option[String]],
  locked: Output[Option[Boolean]],
  max: Output[Option[Int]],
  maxRandomNumber: Output[Option[String]],
  min: Output[Option[Int]],
  minRandomNumber: Output[Option[String]],
  nonce: Output[Option[String]],
  numberOfBytes: Output[Option[Int]],
  operandOne: Output[Option[String]],
  paramName: Output[Option[String]],
  pathComponentOffset: Output[Option[String]],
  prependBytes: Output[Option[Boolean]],
  queryParameterName: Output[Option[String]],
  regex: Output[Option[String]],
  replacement: Output[Option[String]],
  responseHeaderName: Output[Option[String]],
  separator: Output[Option[String]],
  setCookieName: Output[Option[String]],
  startIndex: Output[Option[String]],
  subString: Output[Option[String]],
  templateUuid: Output[Option[String]],
  transform: Output[Option[String]],
  uuid: Output[Option[String]],
  valueSource: Output[Option[String]],
  variableName: Output[Option[String]],
  variableValue: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorSetVariableArgs:
  def apply(
    algorithm: Input.Optional[String] = None,
    caseSensitive: Input.Optional[Boolean] = None,
    certificateFieldName: Input.Optional[String] = None,
    cookieName: Input.Optional[String] = None,
    deviceProfile: Input.Optional[String] = None,
    encryptionKey: Input.Optional[String] = None,
    encryptionMode: Input.Optional[String] = None,
    endIndex: Input.Optional[String] = None,
    exceptChars: Input.Optional[String] = None,
    extractLocation: Input.Optional[String] = None,
    forceChars: Input.Optional[String] = None,
    formatString: Input.Optional[String] = None,
    generator: Input.Optional[String] = None,
    globalSubstitution: Input.Optional[Boolean] = None,
    headerName: Input.Optional[String] = None,
    hmacAlgorithm: Input.Optional[String] = None,
    hmacKey: Input.Optional[String] = None,
    initializationVector: Input.Optional[String] = None,
    ipVersion: Input.Optional[String] = None,
    ipv4Prefix: Input.Optional[Int] = None,
    ipv6Prefix: Input.Optional[Int] = None,
    locationId: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    max: Input.Optional[Int] = None,
    maxRandomNumber: Input.Optional[String] = None,
    min: Input.Optional[Int] = None,
    minRandomNumber: Input.Optional[String] = None,
    nonce: Input.Optional[String] = None,
    numberOfBytes: Input.Optional[Int] = None,
    operandOne: Input.Optional[String] = None,
    paramName: Input.Optional[String] = None,
    pathComponentOffset: Input.Optional[String] = None,
    prependBytes: Input.Optional[Boolean] = None,
    queryParameterName: Input.Optional[String] = None,
    regex: Input.Optional[String] = None,
    replacement: Input.Optional[String] = None,
    responseHeaderName: Input.Optional[String] = None,
    separator: Input.Optional[String] = None,
    setCookieName: Input.Optional[String] = None,
    startIndex: Input.Optional[String] = None,
    subString: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    transform: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None,
    valueSource: Input.Optional[String] = None,
    variableName: Input.Optional[String] = None,
    variableValue: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorSetVariableArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorSetVariableArgs(
      algorithm = algorithm.asOptionOutput(isSecret = false),
      caseSensitive = caseSensitive.asOptionOutput(isSecret = false),
      certificateFieldName = certificateFieldName.asOptionOutput(isSecret = false),
      cookieName = cookieName.asOptionOutput(isSecret = false),
      deviceProfile = deviceProfile.asOptionOutput(isSecret = false),
      encryptionKey = encryptionKey.asOptionOutput(isSecret = false),
      encryptionMode = encryptionMode.asOptionOutput(isSecret = false),
      endIndex = endIndex.asOptionOutput(isSecret = false),
      exceptChars = exceptChars.asOptionOutput(isSecret = false),
      extractLocation = extractLocation.asOptionOutput(isSecret = false),
      forceChars = forceChars.asOptionOutput(isSecret = false),
      formatString = formatString.asOptionOutput(isSecret = false),
      generator = generator.asOptionOutput(isSecret = false),
      globalSubstitution = globalSubstitution.asOptionOutput(isSecret = false),
      headerName = headerName.asOptionOutput(isSecret = false),
      hmacAlgorithm = hmacAlgorithm.asOptionOutput(isSecret = false),
      hmacKey = hmacKey.asOptionOutput(isSecret = false),
      initializationVector = initializationVector.asOptionOutput(isSecret = false),
      ipVersion = ipVersion.asOptionOutput(isSecret = false),
      ipv4Prefix = ipv4Prefix.asOptionOutput(isSecret = false),
      ipv6Prefix = ipv6Prefix.asOptionOutput(isSecret = false),
      locationId = locationId.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      max = max.asOptionOutput(isSecret = false),
      maxRandomNumber = maxRandomNumber.asOptionOutput(isSecret = false),
      min = min.asOptionOutput(isSecret = false),
      minRandomNumber = minRandomNumber.asOptionOutput(isSecret = false),
      nonce = nonce.asOptionOutput(isSecret = false),
      numberOfBytes = numberOfBytes.asOptionOutput(isSecret = false),
      operandOne = operandOne.asOptionOutput(isSecret = false),
      paramName = paramName.asOptionOutput(isSecret = false),
      pathComponentOffset = pathComponentOffset.asOptionOutput(isSecret = false),
      prependBytes = prependBytes.asOptionOutput(isSecret = false),
      queryParameterName = queryParameterName.asOptionOutput(isSecret = false),
      regex = regex.asOptionOutput(isSecret = false),
      replacement = replacement.asOptionOutput(isSecret = false),
      responseHeaderName = responseHeaderName.asOptionOutput(isSecret = false),
      separator = separator.asOptionOutput(isSecret = false),
      setCookieName = setCookieName.asOptionOutput(isSecret = false),
      startIndex = startIndex.asOptionOutput(isSecret = false),
      subString = subString.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      transform = transform.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false),
      valueSource = valueSource.asOptionOutput(isSecret = false),
      variableName = variableName.asOptionOutput(isSecret = false),
      variableValue = variableValue.asOptionOutput(isSecret = false)
    )
