package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenArgs private(
  enableEs256: Output[Option[Boolean]],
  enableRs256: Output[Option[Boolean]],
  extractLocation: Output[Option[String]],
  headerName: Output[Option[String]],
  jwt: Output[Option[String]],
  locked: Output[Option[Boolean]],
  queryParameterName: Output[Option[String]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenArgs:
  def apply(
    enableEs256: Input.Optional[Boolean] = None,
    enableRs256: Input.Optional[Boolean] = None,
    extractLocation: Input.Optional[String] = None,
    headerName: Input.Optional[String] = None,
    jwt: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    queryParameterName: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenArgs(
      enableEs256 = enableEs256.asOptionOutput(isSecret = false),
      enableRs256 = enableRs256.asOptionOutput(isSecret = false),
      extractLocation = extractLocation.asOptionOutput(isSecret = false),
      headerName = headerName.asOptionOutput(isSecret = false),
      jwt = jwt.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      queryParameterName = queryParameterName.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
